---
generated_at: 2026-02-01 10:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-vmstat - 仮想メモリ統計レポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. 該当なし

## 2) 参照した情報（Evidence一覧）

- E-01: `usr.bin/vmstat/vmstat.c` 100-152行目（__vmmeter構造体）
- E-02: `usr.bin/vmstat/vmstat.c` 198-392行目（main関数）
- E-03: `usr.bin/vmstat/vmstat.c` 480-581行目（fill_vmmeter関数）
- E-04: `usr.bin/vmstat/vmstat.c` 636-817行目（dovmstat関数）
- E-05: `usr.bin/vmstat/vmstat.c` 819-858行目（printhdr関数）
- E-06: `usr.bin/vmstat/vmstat.c` 924-1043行目（dosum関数）
- E-07: `usr.bin/vmstat/vmstat.c` 1046-1067行目（doforkst関数）
- E-08: `usr.bin/vmstat/vmstat.c` 1250-1330行目（dointr関数）
- E-09: `usr.bin/vmstat/vmstat.c` 1332-1397行目（domemstat_malloc関数）
- E-10: `usr.bin/vmstat/vmstat.c` 1399-1456行目（domemstat_zone関数）
- E-11: `usr.bin/vmstat/vmstat.c` 1123-1141行目（cpustats関数）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 7つの出力モードをtodoビットマスクで管理 | E-02 (165-172行目: #define FORKSTAT～OBJSTAT) | ○ |
| C-02 | __vmmeter構造体で60以上のVMカウンタを保持 | E-01 (100-152行目) | ○ |
| C-03 | fill_vmmeterがsysctlまたはkvmで値を取得 | E-03 (486-579行目) | ○ |
| C-04 | rateマクロで差分値を1秒あたりの率に変換 | E-04 (762行目) | ○ |
| C-05 | xo_emitでlibxo形式出力をサポート | E-04 (757-793行目) | ○ |
| C-06 | VMSTAT_XO_VERSION "2"でバージョン管理 | E-02 (68行目, 284行目) | ○ |
| C-07 | -hオプションのデフォルト値はisatty(1)に依存 | E-02 (216行目) | ○ |
| C-08 | vmtotal.t_rq - 1 で実行可能プロセス数を計算 | E-04 (758行目) | ○ |
| C-09 | ページイン = v_swapin + v_vnodein | E-04 (775-776行目) | ○ |
| C-10 | -Pオプションでper-CPU統計を表示 | E-04 (795-796行目), E-11 (1144行目) | ○ |
| C-11 | printhdr関数で端末行数に基づくヘッダー制御 | E-05 (857行目: hdrcnt = winlines) | ○ |
| C-12 | SIGWINCHでdoresize呼び出し | E-04 (667行目), E-04 (887-909行目) | ○ |
| C-13 | fork/vfork/rforkの統計を別々に出力 | E-07 (1051-1066行目) | ○ |
| C-14 | 割り込み統計でperiod_msベースのrate計算 | E-08 (1231行目, 1301行目) | ○ |
| C-15 | mallocメモリ統計をmemstat API経由で取得 | E-09 (1340行目: memstat_sysctl_malloc) | ○ |
| C-16 | UMAゾーン統計をmemstat API経由で取得 | E-10 (1412行目: memstat_sysctl_uma) | ○ |
| C-17 | dosum関数でVFS name cache統計も出力 | E-06 (1016-1041行目: nchstats) | ○ |
| C-18 | _WANT_VMMETERマクロでvmmeter内部構造にアクセス | E-01 (44行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 単一ファイルで完結し、全関数をソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] _vm_cntと_cntのシンボル互換性（retry_nlist, 297-311行目）を確認
- [ ] human readable出力と非human readable出力の切り替え動作を確認
- [ ] per-CPU統計（-P）のCPUマスク処理の正確性を確認
